﻿var quotas = {
    inPercent: $("#InPercent").val() == "True",
    canModifyQuotas: $("#CanModifyQuotas").val() == "True",
    canModifyQuotaDefinitions: $("#CanModifyQuotaDefinitions").val() == "True",
    context: $(".v-quotas"),
    datatable: null,
    initializeDataTable: function () {
        var objectiveSuffix = null;
        var objectiveColumn = "Objective";

        if (quotas.inPercent) {
            objectiveSuffix = "%";
            objectiveColumn = "ObjectivePercentage";
        }

        var toolBarItems = [];
        var contextMenuItems = [];

        if (quotas.canModifyQuotas) {
            toolBarItems = [
                { "Action": "open", "Label": resources.Open },
                { "Action": "halfopen", "Label": resources.HalfOpen },
                { "Action": "close", "Label": resources.Close },
                { "Action": "modify", "Label": resources.ModifyObjective }
            ];

            if (quotas.canModifyQuotaDefinitions) {
                toolBarItems.push({ "Action": "delete", "Label": resources.Delete });

                contextMenuItems = [{ "Action": "insertabove", "Label": resources.InsertStratumAbove, "DisplayCondition": function () { return quotas.canModifyQuotas; } },
                                    { "Action": "insertbelow", "Label": resources.InsertStratumBelow, "DisplayCondition": function () { return quotas.canModifyQuotas; } },
                                    { "Divider": true },
                                    { "Action": "delete", "Label": resources.Delete }];
            }

            contextMenuItems.push({ "Action": "edit", "Label": resources.Properties });
            contextMenuItems.push({ "Divider": true });
            contextMenuItems.push({ "Action": "open", "Label": resources.Open, "DisplayCondition": function (data) { return data.Status != 0; } });
            contextMenuItems.push({ "Action": "halfopen", "Label": resources.HalfOpen, "DisplayCondition": function (data) { return data.Status != 1; } });
            contextMenuItems.push({ "Action": "close", "Label": resources.Close, "DisplayCondition": function (data) { return data.Status != 2; } });
        }

        this.datatable = $(".h-quotasTable", quotas.context).a4datatable({
            advancedFilter: true,
            height: "full",
            multiEdit: function () { return quotas.canModifyQuotas; },
            stateKey: "Quotas",
            ajaxAction: a4.getSurveyAction("GetStrata", "Quotas"),
            columns: [
                { "Data": "OutOfSyncMessage", "Tooltip": true },
                { "Name": "Position", "Data": "Position", "Title": "#" },
                { "Name": "Id", "Data": "Id", "Title": resources.Id, "Key": true },
                { "Name": "Status", "Data": "StatusEnum", "Title": resources.Status, "Type": "enum", "EnumType": "QuotaStatus", "Editable": quotas.canModifyQuotas },
                { "Name": "Criterion", "Data": "Criterion", "Title": resources.Criterion, "Editable": quotas.canModifyQuotaDefinitions },
                { "Name": "Label", "Data": "Label", "Title": resources.Label, "Editable": quotas.canModifyQuotaDefinitions },
                { "Name": "Objective", "Data": objectiveColumn, "Title": resources.Objective, "Type": "numeric", "Suffix": objectiveSuffix, "Editable": (quotas.canModifyQuotas ? { "MinValue": 0 } : null) },
                { "Name": "Unused", "Data": "Unused", "Title": resources.Unused },
                { "Name": "Online", "Data": "Online", "Title": resources.Online },
                { "Name": "Completed", "Data": "Completed", "Title": resources.Completed },
                { "Name": "ToDo", "Data": "ToDo", "Title": resources.ToDo },
                { "Name": "Achievement", "Data": "Achievement", "Title": resources.Achievement, "Suffix": "%" }
            ],
            localizableTexts: { "All": resources.AllStrata, "Search": resources.SearchStrata },
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var strataIds = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "open":
                        quotas.updateStrataStatus(strataIds, 0);
                        break;
                    case "halfopen":
                        quotas.updateStrataStatus(strataIds, 1);
                        break;
                    case "close":
                        quotas.updateStrataStatus(strataIds, 2);
                        break;
                    case "modify":
                        modalDialog.showWindow(a4.getSurveyAction("ModifyObjectives", "Quotas"), 200, 500);
                        break;
                    case "delete":
                        quotas.deleteStrata(strataIds);
                        break;
                };
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;
                var strataIds = [row.Id];

                switch (action) {
                    case "open":
                        quotas.updateStrataStatus(strataIds, 0);
                        break;
                    case "halfopen":
                        quotas.updateStrataStatus(strataIds, 1);
                        break;
                    case "close":
                        quotas.updateStrataStatus(strataIds, 2);
                        break;
                    case "insertabove":
                        modalDialog.showWindow(a4.getSurveyAction("Edit", "Quotas", { position: row.Position }), 500, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "insertbelow":
                        modalDialog.showWindow(a4.getSurveyAction("Edit", "Quotas", { position: row.Position + 1 }), 500, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "edit":
                        modalDialog.showWindow(a4.getSurveyAction("Edit", "Quotas", { id: row.Id }), 550, 700, { afterClose: function () { quotas.refreshContent(true); } });
                        break;
                    case "delete":
                        quotas.deleteStrata(strataIds);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.StatusOpen, "AjaxParams": { "status": 0 } },
                    { "Label": resources.StatusHalfOpen, "AjaxParams": { "status": 1 } },
                    { "Label": resources.StatusClosed, "AjaxParams": { "status": 2 } }
                ]
            },
            draw: function () {
                a4.callServerMethod(a4.getSurveyAction("GetOutdatedStrataCount", "Quotas"), {}, function (result) {
                    $(".v-outdatedStrataPanel", quotas.context).toggle(result > 0);
                    $(".v-outdatedStrataCount", quotas.context).text(result);
                });
                a4.callServerMethod(a4.getSurveyAction("CalculateQuotas", "Quotas"));
                a4.callServerMethod(a4.getSurveyAction("GetCompletedSurveysCount", "Quotas"), {}, function (result) {
                    $(".v-completedSurveysCount", quotas.context).text(result);
                });
            },
            rowsUpdated: function (event, data) {
                a4.callServerMethod(a4.getSurveyAction("UpdateStrata", "Quotas"), { strata: data.rows }, function () { data.multiEditSaveCallback(); quotas.refreshContent(true); });
            },
            cellCreated: function (evt, data) {
                if (data.fieldName == "Status")
                    $(data.cell).addClass("stratum-status-" + data.row.Status);

            }
        });
    },
    refreshContent: function (refreshSurveyMenu) {
        var self = this;
        a4.showBusyBox();
        function refreshAndHide() {
            self.datatable.a4datatable("refresh");
            a4.hideBusyBox();
        }

        a4.callServerMethod(
            a4.getSurveyAction("CalculateWeights", "Quotas"),
            {},
            refreshAndHide,
            refreshAndHide
        );
        

        if (refreshSurveyMenu) {
            if (typeof surveyMenu != 'undefined') {
                surveyMenu.refresh();
            } else {
                a4.parent().surveyMenu.refresh();
            }
        }
    },
    updateStrataStatus: function (strataIds, status) {
        a4.callServerMethod(a4.getSurveyAction("UpdateStrataStatus", "Quotas"), { strataIds: strataIds, status: status },
            function (result) {
                quotas.refreshContent();
            });
    },
    updateStrataObjectives: function (objective) {
        if (objective) {
            var rows = quotas.datatable.a4datatable("getSelectedItems");
            var strataIds = _.map(rows, function (row) { return row.Id });

            a4.callServerMethod(a4.getSurveyAction("UpdateStrataObjectives", "Quotas"), { strataIds: strataIds, objective: objective },
                    function (result) {
                        quotas.refreshContent();
                    });
        }
    },
    deleteStrata: function (strataIds) {
        modalDialog.showConfirmDialog(confirmDeleteStrataResources, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteStrata", "Quotas"), { strataIds: strataIds },
                function (result) {
                    quotas.refreshContent(true);
                });
        }, 250, 500, true, { "count": strataIds.length });
    },
    bindEvents: function () {
        $(".h-addStrataMenu", this.context).on("click", "li.h-addStratum", function () {
            modalDialog.showWindow(a4.getSurveyAction("Edit", "Quotas"), 500, 700, { afterClose: function () { quotas.refreshContent(true); } });
        });

        $(".h-addStrataMenu", this.context).on("click", "li.h-addMultipleStrata", function () {
            modalDialog.showWindow(a4.getSurveyAction("AddMultipleStrata", "Quotas"), 700, 800);
        });

        this.context.on("click", ".h-deleteAll", function () {
            modalDialog.showConfirmDialog(confirmDeleteAllStrataResources, function () {
                a4.callServerMethod(a4.getSurveyAction("DeleteAllStrata", "Quotas"), {},
                    function (result) {
                        quotas.refreshContent(true);
                    });
            }, 250, 500, true, {});
        });

        this.context.on("click", ".h-activateQuotas", function () {
            a4.callServerMethod(a4.getSurveyAction("ActivateQuotas", "Quotas"), {},
            function (result) {
                $(".v-inactiveQuotasMessage", quotas.context).hide();
                quotas.refreshContent(true);
            });
        });

        this.context.on("click", ".h-copyStrata", function () {
            modalDialog.showWindow(a4.getSurveyAction("CopyStrata", "Quotas"), 250, 600, { afterClose: function () { quotas.refreshContent(true); } });
        });

        this.context.on("click", ".h-importQuotas", function () {
            modalDialog.showWindow(a4.getSurveyAction("ImportStrata", "Quotas"), 450, null, { afterClose: function () { quotas.refreshContent(true); } });
        });

        this.context.on("click", ".h-exportQuotas", function () {
            a4.showBusyBox();

            a4.callServerMethod(a4.getSurveyAction("ExportStrata", "Quotas"), {},
                function (result) {
                    a4.hideBusyBox();
                    window.location = a4.getSurveyAction("GetStrataFile", "Quotas", { fileName: result });
                });
        });

        this.context.on("click", ".h-editObjective", function () {
            $(".v-editObjective .v-objectiveTextbox", quotas.context).val($(".v-objectiveLabel", quotas.context).text());
            quotas.toggleEditObjectivePanel(true);
        });

        this.context.on("click", ".h-editObjectiveCancel", function () {
            quotas.toggleEditObjectivePanel(false);
        });

        this.context.on("click", ".h-editObjectiveConfirm", function () {
            var objective = $(".v-editObjective .v-objectiveTextbox", quotas.context).val();
            if (objective) {
                a4.callServerMethod(a4.getSurveyAction("UpdateGlobalObjective", "Quotas"), { objective: objective },
                    function (result) {
                        $(".v-displayObjective .v-objectiveLabel", quotas.context).text(objective);
                        quotas.toggleEditObjectivePanel(false);
                        quotas.refreshContent(true);
                    });
            }
            else {
                quotas.toggleEditObjectivePanel(false);
            }
        });

        this.context.on("click", ".h-calculateCounters", function () {
            a4.callServerMethod(a4.getSurveyAction("CalculateQuotas", "Quotas"), {}, function (result) { });
        });
    },
    toggleEditObjectivePanel: function (show) {
        $(".v-displayObjective", quotas.context).css("display", show ? "none" : "inline-block");
        $(".v-editObjective", quotas.context).css("display", show ? "inline-block" : "none");
    },
    formatObjectiveInput: function () {
        var maxObjective = quotas.inPercent ? "100" : "999999999999999";
        $("#Objective").autoNumeric({ aPad: false, vMin: '0', vMax: maxObjective, mDec: '0', aSep: '' });
    }
}

$(document).ready(function () {
    if (quotas.context.length > 0) {
        quotas.initializeDataTable();
        quotas.bindEvents();

        $(".v-editObjective .v-objectiveTextbox", quotas.context).autoNumeric({ aPad: false, vMin: '0', vMax: '999999999999999', mDec: '0', aSep: '' });        
    }

    if ($(".v-copyStrata").length > 0) {
        $(".v-copyStrata .h-surveys").a4autocomplete({
            ajaxAction: a4.getAction("GetSurveysForAutoComplete", "Home", "Survey"),
            ajaxParams: { withStrataOnly: true },
            categoryProperty: "Folder",
            altValueField: $(".v-copyStrata #SourceId")
        });
    }
});